// Mit Mehrdeutigkeit beim Überladen

public class Bruch {
    private long zaehler;          // wird automatisch mit 0 initialisiert
    private long nenner = 1;       // wird manuell mit 1 initialisiert
    private String etikett = "";  // die Referenztyp-Init. auf null wird ersetzt

    public void setzeZaehler(int z) {zaehler = z;}

    public boolean setzeNenner(int n) {
        if (n != 0)	{
            nenner = n;
            return true;
        } else
            return false;
    }

    public void setzeEtikett(String eti) {
        if (eti.length() <= 40)
            etikett = eti;
        else
            etikett = eti.substring(0, 40);
    }

    public long gibZaehler() {return zaehler;}

    public long gibNenner()	{return nenner;}

    public String gibEtikett()	{return etikett;}

    public void kuerze() {
        if (zaehler != 0) {
            long rest;
            long ggt = Math.abs(zaehler);
            long divisor = Math.abs(nenner);
            do {
                rest = ggt % divisor;
                ggt = divisor;
                divisor = rest;
            } while (rest > 0);
            zaehler /= ggt;
            nenner  /= ggt;
        } else
            nenner = 1;
    }


	public void addiere(Bruch b) {
		zaehler = zaehler*b.nenner + b.zaehler*nenner;
		nenner = nenner*b.nenner;
		kuerze();
	}

    public boolean addiere(int z, int n, boolean autokurz) {
        if (n != 0) {
            zaehler = zaehler*n + z*nenner;
            nenner = nenner*n;
            if (autokurz)
                kuerze();
            return true;
        } else
            return false;
    }

    public void addiere(Bruch... bar) {
        for (Bruch b : bar)
            addiere(b);
    }

    public void addiere(long z, int n) {
        if (n == 0) return;
        zaehler = zaehler*n + z*nenner;
        nenner = nenner*n;
    }

    public void addiere(int z, long n) {
        if (n == 0) return;
        zaehler = zaehler*n + z*nenner;
        nenner = nenner*n;
    }

    public void frage() {
		int n;
		do {
			setzeZaehler(Simput.gint("Zähler: "));
		} while (Simput.checkError());
		do {
			// Bei irregulärer Eingabe liefert gint() eine 0 und setzt einen Fehlerindikator.
			n = Simput.gint("Nenner: ");
			if (n == 0 && !Simput.checkError())
				IO.println("Der Nenner darf nicht Null werden!\n");
		} while (n == 0);
		setzeNenner(n);
	}

	public void zeige() {
		String luecke = "";
		final int el = etikett.length();
		for (int i = 1; i <= el; i++)
			luecke = luecke + " ";
		IO.println(" " + luecke  + "   " + zaehler + "\n" +
                   " " + etikett + " -----\n" +
                   " " + luecke  + "   " + nenner + "\n");
	}
}